
<?php $__env->startSection('title', __('Sign-in')); ?>
<?php $__env->startSection('content'); ?>
<?php if( recaptcha() ): ?>
<?php $__env->startPush('header'); ?>
<script>
    grecaptcha.ready(function () { grecaptcha.execute('<?php echo e(recaptcha('site')); ?>', { action: 'login' }).then(function (token) { if(token) { document.getElementById('recaptcha').value = token; } }); });
</script>
<?php $__env->stopPush(); ?>
<?php endif; ?>
<div class="page-ath-form">
    <h2 class="page-ath-heading"><?php echo e(__('Sign in')); ?><small><?php echo e(__('with your')); ?> <?php echo e(site_info('name')); ?>

            <?php echo e(__('Account')); ?></small></h2>
    <form class="login-form validate validate-modern"
        action="<?php echo e((is_maintenance() ? route('admin.login') : route('login'))); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <div class="input-item">
            <input type="email" placeholder="<?php echo e(__('Your Email')); ?>" data-msg-required="<?php echo e(__('Required.')); ?>"
                class="input-bordered<?php echo e($errors->has('email') ? ' input-error' : ''); ?>" name="email"
                value="<?php echo e(old('email')); ?>" required autofocus>
        </div>
        <div class="input-item">
            <input type="password" placeholder="<?php echo e(__('Password')); ?>" minlength="6"
                data-msg-required="<?php echo e(__('Required.')); ?>"
                data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 6])); ?>"
                class="input-bordered<?php echo e($errors->has('password') ? ' input-error' : ''); ?>" name="password" required>
        </div>
        <?php if(! is_maintenance()): ?>
        <div class="d-flex justify-content-between align-items-center">
            <div class="input-item text-left">
                <input class="input-checkbox input-checkbox-md" type="checkbox" name="remember" id="remember-me"
                    <?php echo e(old('remember') ? 'checked' : ''); ?>>
                <label for="remember-me"><?php echo e(__('Remember Me')); ?></label>
            </div>
            <div>
                <a href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forgot password?')); ?></a>
                <div class="gaps-2x"></div>
            </div>
        </div>
        <?php endif; ?>
        <?php if( recaptcha() ): ?>
        <input type="hidden" name="recaptcha" id="recaptcha">
        <?php endif; ?>
        <button type="submit" class="btn btn-primary btn-block"><?php echo e(__('Sign In')); ?></button>
    </form>
    <?php if(! is_maintenance()): ?>
    <?php if(Schema::hasTable('settings')): ?>
    <?php if(
    (get_setting('site_api_fb_id', env('FB_CLIENT_ID', '')) != '' && get_setting('site_api_fb_secret',
    env('FB_CLIENT_SECRET', '')) != '') ||
    (get_setting('site_api_google_id', env('GOOGLE_CLIENT_ID', '')) != '' && get_setting('site_api_google_secret',
    env('GOOGLE_CLIENT_SECRET', '')) != '')
    ): ?>
    <div class="sap-text"><span><?php echo e(__('Or Sign in with')); ?></span></div>
    <ul class="row guttar-20px guttar-vr-20px">
        <?php if(get_setting('site_api_fb_id', env('FB_CLIENT_ID', '')) != '' && get_setting('site_api_fb_secret',
        env('FB_CLIENT_SECRET', '')) != ''): ?>
        <li class="col"><a href="<?php echo e(route('social.login', 'facebook')); ?>"
                class="btn btn-outline btn-dark btn-facebook btn-block"><em
                    class="fab fa-facebook-f"></em><span><?php echo e(__('Facebook')); ?></span></a></li>
        <?php endif; ?>
        <?php if(get_setting('site_api_google_id', env('GOOGLE_CLIENT_ID', '')) != '' &&
        get_setting('site_api_google_secret', env('GOOGLE_CLIENT_SECRET', '')) != ''): ?>
        <li class="col"><a href="<?php echo e(route('social.login', 'google')); ?>"
                class="btn btn-outline btn-dark btn-google btn-block"><em
                    class="fab fa-google"></em><span><?php echo e(__('Google')); ?></span></a></li>
        <?php endif; ?>
    </ul>
    <?php endif; ?>
    <?php endif; ?>

    <div class="gaps-4x"></div>
    <div class="form-note">
        <?php echo e(__('Don’t have an account?')); ?> <a href="<?php echo e(route('register')); ?>"> <strong><?php echo e(__('Sign up here')); ?></strong></a>
    </div>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>