<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">
<head>
    <meta charset="utf-8">
    <meta name="apps" content="<?php echo e(site_whitelabel('apps')); ?>">
    <meta name="author" content="<?php echo e(site_whitelabel('author')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="site-token" content="<?php echo e(site_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(site_favicon()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(site_whitelabel('title')); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset(style_theme('vendor'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(style_theme('user'))); ?>">
    <?php if( recaptcha() ): ?>
    <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(recaptcha('site')); ?>"></script>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('header'); ?>
    <?php if(get_setting('site_header_code', false)): ?>
    <?php echo e(html_string(get_setting('site_header_code'))); ?>

    <?php endif; ?>
</head>
<?php 
$auth_layout = (gws('theme_auth_layout', 'default'));
$logo_light = ($auth_layout=='center-dark') ? 'logo-light' : 'logo';
$body_class = ($auth_layout=='center-dark'||$auth_layout=='center-light') ? ' page-ath-alt' : '';
$body_bgc   = ($auth_layout=='center-dark') ? ' bg-secondary' : '';
$wrap_class = ($auth_layout=='default') ? ' flex-row-reverse' : '';

$header_logo = '<div class="page-ath-header"><a href="'.url('/').'" class="page-ath-logo"><img class="page-ath-logo-img" src="'. site_whitelabel($logo_light) .'" srcset="'. site_whitelabel($logo_light.'2x') .'" alt="'. site_whitelabel('name') .'"></a></div>';
?>
<body class="page-ath theme-modern page-ath-modern<?php echo e($body_class.$body_bgc); ?>">

    <div class="page-ath-wrap<?php echo e($wrap_class); ?>">
        <div class="page-ath-content">
            <?php echo $header_logo; ?>

            <?php echo $__env->yieldContent('content'); ?>
            
            <div class="page-ath-footer">
                <?php if(is_show_social('login')): ?>
                    <?php echo UserPanel::social_links('', ['class' => 'mb-3']); ?>

                    <?php echo UserPanel::footer_links(['lang' => true], ['class' => 'guttar-20px align-items-center']); ?>

                    <?php echo UserPanel::copyrights('div'); ?>

                <?php else: ?>
                    <?php echo UserPanel::footer_links(['lang' => true, 'copyright'=>true], ['class' => 'guttar-20px align-items-center']); ?>

                <?php endif; ?>
            </div>
        </div>
        <?php if($auth_layout=='default' || $auth_layout=='alter'): ?>
        <div class="page-ath-gfx" style="background-image: url(<?php echo e(asset('images/ath-gfx.png')); ?>);">
            <div class="w-100 d-flex justify-content-center">
                <div class="col-md-8 col-xl-5">
                    
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

<?php if(gws('theme_custom')): ?>
    <link rel="stylesheet" href="<?php echo e(asset(style_theme('custom'))); ?>">
<?php endif; ?>
    <script>
        var base_url = "<?php echo e(url('/')); ?>",
        csrf_token = document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
        layouts_style = "modern";
    </script>
    <script src="<?php echo e(asset('assets/js/jquery.bundle.js').css_js_ver()); ?>"></script>
    <script src="<?php echo e(asset('assets/js/script.js').css_js_ver()); ?>"></script>
    <script type="text/javascript">
        jQuery(function(){
            var $frv = jQuery('.validate');
            if($frv.length > 0){ $frv.validate({ errorClass: "input-bordered-error error" }); }
        });
    </script>
    <?php echo $__env->yieldPushContent('footer'); ?>

    <?php if(get_setting('site_footer_code', false)): ?>
    <?php echo e(html_string(get_setting('site_footer_code'))); ?>

    <?php endif; ?>
</body>
</html>