<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">
<head>
    <meta charset="utf-8">
    <meta name="apps" content="<?php echo e(site_whitelabel('apps')); ?>">
    <meta name="author" content="<?php echo e(site_whitelabel('author')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="site-token" content="<?php echo e(site_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(site_favicon()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(site_whitelabel('title')); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset(style_theme('vendor'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(style_theme('user'))); ?>">
    <?php echo $__env->yieldPushContent('header'); ?>
<?php if(get_setting('site_header_code', false)): ?>
    <?php echo e(html_string(get_setting('site_header_code'))); ?>

<?php endif; ?>
</head>
<body class="user-dashboard page-user theme-modern">
    <div class="topbar-wrap">
        <div class="topbar is-sticky">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ul class="topbar-nav d-lg-none">
                        <li class="topbar-nav-item relative">
                            <a class="toggle-nav" href="#">
                                <div class="toggle-icon">
                                    <span class="toggle-line"></span>
                                    <span class="toggle-line"></span>
                                    <span class="toggle-line"></span>
                                    <span class="toggle-line"></span>
                                </div>
                            </a>
                        </li>
                    </ul>

                    <a class="topbar-logo" href="<?php echo e(url('/')); ?>">
                        <img height="40" src="<?php echo e(site_whitelabel('logo-light')); ?>" srcset="<?php echo e(site_whitelabel('logo-light2x')); ?>" alt="<?php echo e(site_whitelabel('name')); ?>">
                    </a>
                    <ul class="topbar-nav">
                        <li class="topbar-nav-item relative">
                            <span class="user-welcome d-none d-lg-inline-block"><?php echo e(__('Welcome!')); ?> <?php echo e(auth()->user()->name); ?></span>
                            <a class="toggle-tigger user-thumb" href="#"><em class="ti ti-user"></em></a>
                            <div class="toggle-class dropdown-content dropdown-content-right dropdown-arrow-right user-dropdown">
                                <?php echo UserPanel::user_balance(); ?>

                                <?php echo UserPanel::user_menu_links(); ?>

                                <?php echo UserPanel::user_logout_link(); ?>

                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="navbar">
            <div class="container">
                <div class="navbar-innr">
                    <ul class="navbar-menu" id="main-nav">
                        <li><a href="<?php echo e(route('user.home')); ?>"><em class="ikon ikon-dashboard"></em> <?php echo e(__('Dashboard')); ?></a></li>
                        <li><a href="<?php echo e(route('user.token')); ?>"><em class="ikon ikon-coins"></em> <?php echo e(__('Buy Token')); ?></a></li>
                        <?php if(get_page('distribution', 'status') == 'active'): ?>
                        <li><a href="<?php echo e(route('public.pages', 'distribution')); ?>"><em class="ikon ikon-distribution"></em> <?php echo e(get_page('distribution', 'title')); ?></a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('user.transactions')); ?>"><em class="ikon ikon-transactions"></em> <?php echo e(__('Transactions')); ?></a></li>
                        <?php if(nio_module()->has('Withdraw') && has_route('withdraw:user.index')): ?>
                        <li<?php echo ((is_page('withdraw'))? ' class="active"' : ''); ?>>
                            <a href="<?php echo e(route('withdraw:user.index')); ?>"><em class="ikon ikon-wallet"></em> <?php echo e(__('Withdraw')); ?></a>
                        </li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('user.account')); ?>"><em class="ikon ikon-user"></em> <?php echo e(__('Profile')); ?></a></li>
                        <?php if(gws('user_mytoken_page') == 1): ?>
                        <li><a href="<?php echo e(route('user.token.balance')); ?>"><em class="ikon ikon-my-token"></em> <?php echo e(__('My Token')); ?></a></li>
                        <?php endif; ?>
                        <?php if(gws('main_website_url') != NULL): ?>
                        <li><a href="<?php echo e(gws('main_website_url')); ?>" target="_blank"><em class="ikon ikon-home-link"></em> <?php echo e(__('Main Site')); ?></a></li>
                        <?php endif; ?>
                    </ul>
                    <?php if(!is_kyc_hide()): ?>
                    <ul class="navbar-btns">
                        <?php if(isset(Auth::user()->kyc_info->status) && Auth::user()->kyc_info->status == 'approved'): ?>
                        <li><span class="badge badge-outline badge-success badge-lg"><em class="text-success ti ti-files mgr-1x"></em><span class="text-success"><?php echo e(__('KYC Approved')); ?></span></span></li>
                        <?php else: ?>
                        <li><a href="<?php echo e(route('user.kyc')); ?>" class="btn btn-sm btn-outline btn-light"><em class="text-primary ti ti-files"></em><span><?php echo e(__('KYC Application')); ?></span></a></li>
                        <?php endif; ?>
                    </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="page-content">
        <div class="container">
            <div class="row">
                <?php
                $has_sidebar = isset($has_sidebar) ? $has_sidebar : false;
                $col_side_cls = ($has_sidebar) ? 'col-lg-4' : 'col-lg-12';
                $col_cont_cls = ($has_sidebar) ? 'col-lg-8' : 'col-lg-12';
                $col_cont_cls2 = isset($content_class) ? css_class($content_class) : null;
                $col_side_cls2 = isset($aside_class) ? css_class($aside_class) : null;
                ?>

                <div class="main-content <?php echo e(empty($col_cont_cls2) ? $col_cont_cls : $col_cont_cls2); ?>">
                    <?php if(!has_wallet() && gws('token_wallet_req')==1 && !empty(token_wallet())): ?>
                    <div class="d-lg-none">
                        <?php echo UserPanel::add_wallet_alert(); ?>

                    </div>
                    <?php endif; ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>

                <?php if($has_sidebar==true): ?>
                <div class="aside sidebar-right <?php echo e(empty($col_side_cls2) ? $col_side_cls : $col_side_cls2); ?>">
                    <?php if(!has_wallet() && gws('token_wallet_req')==1 && !empty(token_wallet())): ?>
                    <div class="d-none d-lg-block">
                        <?php echo UserPanel::add_wallet_alert(); ?>

                    </div>
                    <?php endif; ?>
                    <div class="account-info card">
                        <div class="card-innr">
                            <?php echo UserPanel::user_account_status(); ?>

                            <?php if(!empty(token_wallet())): ?>
                            <div class="gaps-2-5x"></div>
                            <?php echo UserPanel::user_account_wallet(); ?>

                            <?php endif; ?>
                        </div>
                    </div>
                    <?php echo (!is_page(get_slug('referral')) ? UserPanel::user_referral_info('') : ''); ?>

                    <?php if(!is_kyc_hide()): ?>
                    <?php echo UserPanel::user_kyc_info(''); ?>

                    <?php endif; ?>
                </div>
                <?php else: ?>
                    <?php echo $__env->yieldPushContent('sidebar'); ?>
                <?php endif; ?>

            </div>
        </div>
    </div>

    <div class="footer-bar">
        <div class="container">
            <?php if(is_show_social('site')): ?>
            <div class="row justify-content-center">
                <div class="col-lg-5 text-center order-lg-last text-lg-right pdb-2x pb-lg-0">
                    <?php echo UserPanel::social_links(); ?>

                </div>
                <div class="col-lg-7">
                    <div class="d-flex align-items-center justify-content-center justify-content-lg-start guttar-15px pdb-1-5x pb-lg-2">
                        <?php echo UserPanel::copyrights('div'); ?>

                        <?php echo UserPanel::language_switcher(); ?>

                    </div>
                    <?php echo UserPanel::footer_links(null, ['class'=>'align-items-center justify-content-center justify-content-lg-start']); ?>

                </div>
            </div>
            <?php else: ?> 
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-7">
                    <?php echo UserPanel::footer_links(null, ['class'=>'guttar-20px']); ?>

                </div>
                <div class="col-lg-5 mt-2 mt-sm-0">
                    <div class="d-flex justify-content-between justify-content-lg-end align-items-center guttar-15px">
                        <?php echo UserPanel::copyrights('div'); ?>

                        <?php echo UserPanel::language_switcher(); ?>

                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php echo $__env->yieldContent('modals'); ?>
    <div id="ajax-modal"></div>
    <div class="page-overlay">
        <div class="spinner"><span class="sp sp1"></span><span class="sp sp2"></span><span class="sp sp3"></span></div>
    </div>

<?php if(gws('theme_custom')): ?>
    <link rel="stylesheet" href="<?php echo e(asset(style_theme('custom'))); ?>">
<?php endif; ?>
    <script>
        var base_url = "<?php echo e(url('/')); ?>",
        <?php echo (has_route('transfer:user.send')) ? 'user_token_send = "'.route('transfer:user.send').'",' : ''; ?>

        <?php echo (has_route('withdraw:user.request')) ? 'user_token_withdraw = "'.route('withdraw:user.request').'",' : ''; ?>

        <?php echo (has_route('user.ajax.account.wallet')) ? 'user_wallet_address = "'.route('user.ajax.account.wallet').'",' : ''; ?>

        csrf_token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    </script>
    <script src="<?php echo e(asset('assets/js/jquery.bundle.js').css_js_ver()); ?>"></script>
    <script src="<?php echo e(asset('assets/js/script.js').css_js_ver()); ?>"></script>
    <script src="<?php echo e(asset('assets/js/app.js').css_js_ver()); ?>"></script>
    <?php echo $__env->yieldPushContent('footer'); ?>
    <script type="text/javascript">
        <?php if(session('resent')): ?>
        show_toast("success","<?php echo e(__('A fresh verification link has been sent to your email address.')); ?>");
        <?php endif; ?>
    </script>
    <?php if(get_setting('site_footer_code', false)): ?>
    <?php echo e(html_string(get_setting('site_footer_code'))); ?>

    <?php endif; ?>
</body>
</html>